package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.martialarts.Maneuver;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ManeuverDialog extends GenericDialog {
	private static final long serialVersionUID = 3066754225637879001L;

	protected Maneuver maneuver;

	private JLabel typeLbl;

	JComboBox typeCombo;

	private JLabel phaseLbl;

	private JLabel phaseValueLbl;

	private JLabel ocvLbl;

	private JLabel ocvValueLbl;

	private JLabel dcvLbl;

	private JLabel dcvValueLbl;

	private JLabel rangeLbl;

	private JLabel rangeValueLbl;

	private JLabel effectLbl;

	private JLabel effectValueLbl;

	public ManeuverDialog(Maneuver pk, boolean isNew, boolean isPower) {
		super(pk, isNew, isPower);
		maneuver = pk;
		init();
		customAdderBtn.setVisible(false);
		addModifierBtn.setVisible(pk.getEffectiveActiveCost() > 0);
		pack();
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 22;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		if ((maneuver.getWeaponEffect() != null)
				&& (maneuver.getWeaponEffect().trim().length() > 0)) {
			panel.add(typeLbl, gbc);
			gbc.gridx = 1;
			gbc.anchor = GridBagConstraints.WEST;
			panel.add(typeCombo, gbc);
		}
		gbc.gridx = 0;
		gbc.gridy = 41;
		gbc.anchor = GridBagConstraints.EAST;
		panel.add(phaseLbl, gbc);
		gbc.gridy = 42;
		panel.add(ocvLbl, gbc);
		gbc.gridy = 43;
		panel.add(dcvLbl, gbc);
		gbc.gridy = 44;
		if (maneuver.getCategory().equalsIgnoreCase("Ranged")) {
			panel.add(rangeLbl, gbc);
		}
		gbc.gridy = 45;
		panel.add(effectLbl, gbc);
		gbc.gridy = 41;
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		panel.add(phaseValueLbl, gbc);
		gbc.gridy = 42;
		panel.add(ocvValueLbl, gbc);
		gbc.gridy = 43;
		panel.add(dcvValueLbl, gbc);
		gbc.gridy = 44;
		if (maneuver.getCategory().equalsIgnoreCase("Ranged")) {
			panel.add(rangeValueLbl, gbc);
		}
		gbc.gridy = 45;
		panel.add(effectValueLbl, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		typeCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				maneuver.setUseWeapon(typeCombo.getSelectedIndex() == 1);
				updateValues();
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		typeLbl = new JLabel("Type");
		ArrayList<String> vec = new ArrayList<String>();
		vec.add("Empty Hand");
		vec.add("Weapon");
		typeCombo = new JComboBox(vec.toArray());
		if (maneuver.useWeapon()) {
			typeCombo.setSelectedIndex(1);
		}
		phaseLbl = new JLabel("Phase:");
		phaseValueLbl = new JLabel(maneuver.getPhase());
		ocvLbl = new JLabel("OCV:");
		ocvValueLbl = new JLabel(maneuver.getOCV());
		dcvLbl = new JLabel("DCV:");
		dcvValueLbl = new JLabel(maneuver.getDCV());
		rangeLbl = new JLabel("Range:");
		rangeValueLbl = new JLabel("" + (maneuver.getRanged() >= 0 ? "+" : "-")
				+ maneuver.getRange());
		effectLbl = new JLabel("Effect:");
		effectValueLbl = new JLabel((maneuver.useWeapon() ? maneuver
				.getWeaponEffect() : maneuver.getEffect()));
		setNameVisible(false);
	}

	@Override
	public void updateValues() {
		super.updateValues();
		if (maneuver.useWeapon()) {
			effectValueLbl.setText(maneuver.getWeaponEffect());
		} else {
			effectValueLbl.setText(maneuver.getEffect());
		}
	}

}